class W3Effect_Rootstrain extends CBaseGameplayEffect
{	
	var effect_entity  		: CEntity;
	var second_effect		: SCustomEffectParams;
	
	default isPositive = false;
	default isNeutral = false;
	default isNegative = true;
	default effectType = EET_Rootstrain;
	default attributeName = 'Rootstrain';
		
	event OnEffectAdded(optional customParams : W3BuffCustomParams)
	{
		super.OnEffectAdded(customParams);	
		
		effect_entity = theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\forest_witch_rootstrain.w2ent", true ), 
												target.GetWorldPosition(), target.GetWorldRotation() );
		/*
		second_effect.effectType = EET_Immobilized;
		second_effect.creator = thePlayer;
		second_effect.sourceName = "forest_witch";
		second_effect.duration = 999;
		target.AddEffectCustom(second_effect);
		*/
		target.EnablePathEngineAgent(false);
	}

	event OnEffectRemoved()
	{
		super.OnEffectRemoved();
		
		effect_entity.StopAllEffects();
		effect_entity.DestroyAfter(5);
		
		if ( !target.HasBuff( EET_BloodLeash ) )
		{
			target.EnablePathEngineAgent(true);
		}
		
		target.RemoveAllBuffsWithSource("forest_witch");
	}
}